<?php
// DB Connection
$connect = mysqli_connect("localhost", "sumisha_agent", "Payment@665", "sumisha_pay");

// Fetch agents
$agents = mysqli_query($connect, "SELECT * FROM agents");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Super Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            overflow-x: hidden;
        }
        .sidebar {
            width: 250px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            background: #212529;
            padding-top: 30px;
        }
        .sidebar a {
            color: #fff;
            padding: 12px 20px;
            display: block;
            text-decoration: none;
            font-size: 16px;
        }
        .sidebar a:hover {
            background: #343a40;
        }
        .content {
            margin-left: 260px;
            padding: 30px;
        }
    </style>
</head>

<body class="bg-light">

<!-- ========== SIDEBAR ========== -->
<div class="sidebar">
    <h4 class="text-white text-center mb-4">Super Admin</h4>

    <a href="dashboard.php">📊 Dashboard</a>
    <a href="create_agent.php">➕ Create Agent</a>
    <a href="agent_details.php">👥 Agent Details</a>
    <a href="approved_payments.php">✔ Approved Payments</a>
    <a href="logout.php" class="text-danger">🚪 Logout</a>
</div>

<!-- ========== MAIN CONTENT ========== -->
<div class="content">
    <h3 class="mb-4">Payment Approval – Agents</h3>

    <table class="table table-bordered bg-white shadow">
        <thead class="table-dark">
            <tr>
                <th>Agent Name</th>
                <th>Status / Action</th>
            </tr>
        </thead>

        <tbody>

        <?php while($a = mysqli_fetch_assoc($agents)) { ?>

            <tr>
                <td><?= $a['name'] ?></td>

                <td width="300px">

                    <?php if($a['payment_approved'] == 0){ ?>

                        <a href="approve_payment.php?id=<?= $a['id'] ?>" 
                           class="btn btn-success btn-sm">
                            Approve
                        </a>
                        <span class="badge bg-warning">Waiting for Approval</span>

                    <?php } else { ?>

                        <span class="badge bg-success mb-2">Approved</span>

                        <?php
                        $agent_id = $a['id'];
                        $payments = mysqli_query(
                            $connect,
                            "SELECT * FROM payments WHERE agent_id='$agent_id' ORDER BY id ASC"
                        );
                        ?>

                        <table class="table table-sm table-striped border mt-2">
                            <thead class="table-secondary">
                                <tr>
                                    <th>Day</th>
                                    <th>Remaining Days</th>
                                    <th>Given</th>
                                    <th>Balance</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php while($p = mysqli_fetch_assoc($payments)) { ?>
                                <tr>
                                    <td><?= $p['day'] ?></td>
                                    <td><?= $p['remaining_days'] ?></td>
                                    <td><?= $p['given'] ?></td>
                                    <td><?= $p['balance'] ?></td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>

                    <?php } ?>

                </td>
            </tr>

        <?php } ?>

        </tbody>
    </table>
</div>

</body>
</html>
