<?php
session_start();
if (!isset($_SESSION['superadmin_id'])) {
    header("Location: index.php");
    exit;
}

$connect = mysqli_connect("localhost", "sumisha_agent", "Payment@665", "sumisha_pay");
if (!$connect) die("DB Error");

$total_amount = 100000;

/* DASHBOARD METRICS */
$total_agents = mysqli_fetch_assoc(
    mysqli_query($connect, "SELECT COUNT(*) AS total FROM agents")
)['total'];

$approved_agents = mysqli_fetch_assoc(
    mysqli_query($connect, "SELECT COUNT(*) AS total FROM agents WHERE payment_approved=1")
)['total'];

$pending_agents = $total_agents - $approved_agents;

$paid_q = mysqli_query(
    $connect,
    "SELECT p.agent_id, COUNT(*) AS paid_days, a.amount
     FROM payments p
     JOIN agents a ON a.id = p.agent_id
     WHERE p.status='paid'
     GROUP BY p.agent_id"
);

$total_paid = 0;
while ($row = mysqli_fetch_assoc($paid_q)) {
    $total_paid += $row['paid_days'] * $row['amount'];
}

$total_balance = ($approved_agents * $total_amount) - $total_paid;
if ($total_balance < 0) $total_balance = 0;
?>

<!DOCTYPE html>
<html>
<head>
    <title>Super Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body { font-family:'Segoe UI',sans-serif; background:#f4f6f9; }

        /* SIDEBAR */
        .sidebar {
            width:240px;
            height:100vh;
            position:fixed;
            background:linear-gradient(180deg,#667eea,#764ba2);
            padding:20px;
            color:#fff;
        }
        .sidebar a {
            display:block;
            padding:12px;
            margin-bottom:10px;
            color:#fff;
            text-decoration:none;
            border-radius:8px;
            font-weight:600;
        }
        .sidebar a:hover { background:rgba(255,255,255,.2); }

        /* TOP NAV */
        .top-nav {
            position:fixed;
            top:0;
            left:240px;
            right:0;
            z-index:1030;
        }

        .content-area {
            margin-left:240px;
            padding:100px 40px 40px;
        }

        .stat-card {
            border-radius:16px;
            padding:25px;
            color:#fff;
            box-shadow:0 8px 20px rgba(0,0,0,.15);
        }

        .bg-blue { background:linear-gradient(135deg,#667eea,#764ba2); }
        .bg-green { background:linear-gradient(135deg,#43cea2,#185a9d); }
        .bg-orange { background:linear-gradient(135deg,#f7971e,#ffd200); }
        .bg-red { background:linear-gradient(135deg,#ff416c,#ff4b2b); }

        /* MOBILE */
        @media (max-width:768px) {
            .sidebar { display:none; }
            .top-nav { left:0; }
            .content-area {
                margin-left:0;
                padding:90px 20px 20px;
            }
        }
    </style>
</head>

<body>

<!-- TOP NAVBAR -->
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm top-nav">
    <div class="container-fluid">
        <span class="navbar-brand fw-bold">👑 Super Admin</span>

        <button class="navbar-toggler d-lg-none" type="button" data-bs-toggle="collapse" data-bs-target="#adminNav">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="adminNav">

            <!-- MOBILE MENU -->
            <ul class="navbar-nav ms-auto d-lg-none">
                <li class="nav-item"><a class="nav-link" href="dashboard.php">🏠 Dashboard</a></li>
                <li class="nav-item"><a class="nav-link" href="create_agent.php">➕ Create Agent</a></li>
                <li class="nav-item"><a class="nav-link" href="agent_details.php">📋 All Agents</a></li>
                <li class="nav-item"><a class="nav-link" href="approved_payments.php">✅ Approved Payments</a></li>
                <li class="nav-item"><a class="nav-link text-danger" href="logout.php">🚪 Logout</a></li>
            </ul>

            <!-- DESKTOP USER -->
            <ul class="navbar-nav ms-auto d-none d-lg-flex align-items-center">
                <li class="nav-item me-3 fw-semibold text-muted">
                    Welcome, Super Admin
                </li>
                <li class="nav-item">
                    <a href="logout.php" class="btn btn-danger btn-sm">Logout</a>
                </li>
            </ul>

        </div>
    </div>
</nav>

<!-- DESKTOP SIDEBAR -->
<div class="sidebar d-none d-md-block">
    <h4 class="mb-4">👑 Super Admin</h4>
    <a href="dashboard.php">🏠 Dashboard</a>
    <a href="create_agent.php">➕ Create Agent</a>
    <a href="agent_details.php">📋 All Agents</a>
    <a href="approved_payments.php">✅ Approved Payments</a>
    <a href="logout.php">🚪 Logout</a>
</div>

<div class="content-area">
    <h2 class="mb-4">Super Admin Dashboard</h2>

    <div class="row g-4">
        <div class="col-md-3 col-6">
            <div class="stat-card bg-blue">
                <h6>Total Agents</h6>
                <h2><?= $total_agents ?></h2>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="stat-card bg-green">
                <h6>Approved</h6>
                <h2><?= $approved_agents ?></h2>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="stat-card bg-orange">
                <h6>Pending</h6>
                <h2><?= $pending_agents ?></h2>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="stat-card bg-red">
                <h6>Balance</h6>
                <h2>₹<?= number_format($total_balance) ?></h2>
            </div>
        </div>

        <div class="col-md-6 col-12">
            <div class="stat-card bg-green mt-4">
                <h6>Total Paid</h6>
                <h2>₹<?= number_format($total_paid) ?></h2>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
