<?php
session_start();

/* =====================
   DB CONNECTION
===================== */
$connect = mysqli_connect("localhost", "sumisha_agent", "Payment@665", "sumisha_pay");
if (!$connect) die("Database connection failed");

/* =====================
   AUTH CHECK (SUPERADMIN)
===================== */
if (!isset($_SESSION['superadmin_id'])) {
    header("Location: index.php");
    exit;
}

/* =====================
   CREATE AGENT
===================== */
$error = "";
if (isset($_POST['submit'])) {

    $name     = mysqli_real_escape_string($connect, $_POST['name']);
    $username = mysqli_real_escape_string($connect, $_POST['username']);
    $password = mysqli_real_escape_string($connect, $_POST['password']); // plain
    $phone    = mysqli_real_escape_string($connect, $_POST['phone']);
    $email    = mysqli_real_escape_string($connect, $_POST['email']);
    $amount   = mysqli_real_escape_string($connect, $_POST['amount']);

    $check = mysqli_query(
        $connect,
        "SELECT id FROM agents 
         WHERE username='$username' OR email='$email'"
    );

    if (mysqli_num_rows($check) > 0) {
        $error = "Username or Email already exists";
    } else {

        mysqli_query(
            $connect,
            "INSERT INTO agents 
            (name, username, password, phone, email, amount, payment_approved)
            VALUES
            ('$name', '$username', '$password', '$phone', '$email', '$amount', 0)"
        );

        header("Location: agent_details.php");
        exit;
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Create Agent</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
        }

        /* DESKTOP SIDEBAR SPACE */
        .content-area {
            margin-left: 240px;
            padding: 40px;
        }

        /* FORM */
        .form-card {
            max-width: 650px;
            background: #fff;
            padding: 30px;
            border-radius: 14px;
            box-shadow: 0 6px 15px rgba(0,0,0,0.1);
        }

        h3 { font-weight: 800; }
        label { font-weight: 600; }

        /* MOBILE */
        @media (max-width: 768px) {
            .content-area {
                margin-left: 0;
                padding: 20px;
            }
        }
    </style>
</head>

<body>

<!-- MOBILE NAVBAR -->
<nav class="navbar navbar-dark bg-dark d-md-none">
    <div class="container-fluid">
        <span class="navbar-brand">👑 Super Admin</span>
        <button class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#mobileMenu">
            <span class="navbar-toggler-icon"></span>
        </button>
    </div>
</nav>

<div class="collapse bg-dark d-md-none" id="mobileMenu">
    <div class="p-3">
        <a href="superadmin_dashboard.php" class="d-block text-white mb-2">🏠 Dashboard</a>
        <a href="create_agent.php" class="d-block text-white mb-2">➕ Create Agent</a>
        <a href="agent_details.php" class="d-block text-white mb-2">📋 All Agents</a>
        <a href="approved_payments.php" class="d-block text-white mb-2">✅ Approved Payments</a>
        <a href="logout.php" class="d-block text-danger">🚪 Logout</a>
    </div>
</div>

<!-- DESKTOP SIDEBAR -->
<div class="d-none d-md-block">
    <?php include 'sidebar.php'; ?>
</div>

<div class="content-area">
    <h3 class="mb-4">➕ Create New Agent</h3>

    <div class="form-card">

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>

        <form method="post">

            <div class="mb-3">
                <label>Agent Name</label>
                <input type="text" class="form-control" name="name" required>
            </div>

            <div class="mb-3">
                <label>Username</label>
                <input type="text" class="form-control" name="username" required>
            </div>

            <div class="mb-3">
                <label>Password</label>
                <input type="text" class="form-control" name="password" required>
            </div>

            <div class="mb-3">
                <label>Phone Number</label>
                <input type="text" class="form-control" name="phone" required>
            </div>

            <div class="mb-3">
                <label>Email Address</label>
                <input type="email" class="form-control" name="email" required>
            </div>

            <div class="mb-4">
                <label>Daily Amount</label>
                <input type="number" class="form-control" name="amount" required>
            </div>

            <button type="submit" name="submit" class="btn btn-primary w-100">
                Create Agent
            </button>

        </form>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
