<?php
session_start();

/* =====================
   AUTH CHECK
===================== */
if (!isset($_SESSION['superadmin_id'])) {
    header("Location: index.php");
    exit;
}

/* =====================
   DB CONNECTION
===================== */
$connect = mysqli_connect("localhost", "sumisha_agent", "Payment@665", "sumisha_pay");
if (!$connect) {
    die("Database connection failed");
}

/* =====================
   FETCH APPROVED AGENTS
===================== */
$agents = mysqli_query(
    $connect,
    "SELECT * FROM agents WHERE payment_approved = 1 ORDER BY id DESC"
);

$total_amount = 100000;
?>

<!DOCTYPE html>
<html>
<head>
    <title>Approved Payments</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
        }

        .content-area {
            margin-left: 240px;
            padding: 40px;
        }

        .card-box {
            background: white;
            padding: 20px;
            border-radius: 14px;
            box-shadow: 0 6px 15px rgba(0,0,0,0.1);
        }

        h3 {
            font-weight: 800;
            margin-bottom: 20px;
        }

        @media (max-width: 768px) {
            .content-area {
                margin-left: 0;
                padding: 20px;
            }
        }
    </style>
</head>

<body>

<!-- MOBILE NAVBAR -->
<nav class="navbar navbar-dark bg-dark d-md-none">
    <div class="container-fluid">
        <span class="navbar-brand">👑 Super Admin</span>
        <button class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#mobileMenu">
            <span class="navbar-toggler-icon"></span>
        </button>
    </div>
</nav>

<!-- MOBILE MENU -->
<div class="collapse bg-dark d-md-none" id="mobileMenu">
    <div class="p-3">
        <a href="superadmin_dashboard.php" class="d-block text-white mb-2">🏠 Dashboard</a>
        <a href="create_agent.php" class="d-block text-white mb-2">➕ Create Agent</a>
        <a href="agent_details.php" class="d-block text-white mb-2">👥 All Agents</a>
        <a href="approved_payments.php" class="d-block text-white mb-2">✅ Approved Payments</a>
        <a href="logout.php" class="d-block text-danger">🚪 Logout</a>
    </div>
</div>

<!-- DESKTOP SIDEBAR -->
<div class="d-none d-md-block">
    <?php include 'sidebar.php'; ?>
</div>

<div class="content-area">
    <h3>✅ Approved Payments</h3>

    <div class="card-box table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Agent Name</th>
                    <th>Phone</th>
                    <th>Daily Amount</th>
                    <th>Total Paid</th>
                    <th>Balance</th>
                    <th>Status</th>
                    <th style="width:130px;">Action</th>
                </tr>
            </thead>
            <tbody>

            <?php
            $count = 1;

            if (mysqli_num_rows($agents) > 0) {

                while ($agent = mysqli_fetch_assoc($agents)) {

                    $paid_days_q = mysqli_query(
                        $connect,
                        "SELECT COUNT(*) AS paid_days 
                         FROM payments 
                         WHERE agent_id='{$agent['id']}' AND status='paid'"
                    );

                    $paid_days = mysqli_fetch_assoc($paid_days_q)['paid_days'];

                    $daily_amount = (int)$agent['amount'];
                    $total_paid   = $paid_days * $daily_amount;
                    $balance      = $total_amount - $total_paid;
                    if ($balance < 0) $balance = 0;
            ?>
                <tr>
                    <td><?= $count ?></td>
                    <td><?= htmlspecialchars($agent['name']) ?></td>
                    <td><?= htmlspecialchars($agent['phone']) ?></td>
                    <td>₹<?= number_format($daily_amount) ?></td>
                    <td>₹<?= number_format($total_paid) ?></td>
                    <td>₹<?= number_format($balance) ?></td>
                    <td><span class="badge bg-success">Approved</span></td>
                    <td>
                        <a href="agent_payment.php?id=<?= $agent['id'] ?>"
                           class="btn btn-sm btn-primary w-100">
                            View
                        </a>
                    </td>
                </tr>
            <?php
                    $count++;
                }

            } else {
            ?>
                <tr>
                    <td colspan="8" class="text-center text-muted">
                        No approved payments found
                    </td>
                </tr>
            <?php } ?>

            </tbody>
        </table>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
