<?php
$connect = mysqli_connect("localhost", "sumisha_agent", "Payment@665", "sumisha_pay");
if (!$connect) die("Database connection failed");

$agent_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

/* =======================
   AGENT INFO
======================= */
$agent_q = mysqli_query($connect, "SELECT * FROM agents WHERE id='$agent_id'");
$agent = mysqli_fetch_assoc($agent_q);
if (!$agent) die("Agent not found");

/* =======================
   CONFIG
======================= */
$total_amount = 100000;
$daily_amount = (int)$agent['amount'];
$total_days   = $daily_amount > 0 ? floor($total_amount / $daily_amount) : 0;

/* =======================
   TOGGLE PAID / UNPAID
======================= */
if (isset($_GET['pay_day'])) {
    $day = (int)$_GET['pay_day'];

    $check = mysqli_query(
        $connect,
        "SELECT id FROM payments 
         WHERE agent_id='$agent_id' AND day_number='$day'"
    );

    if (mysqli_num_rows($check)) {
        mysqli_query(
            $connect,
            "UPDATE payments
             SET status = IF(status='paid','unpaid','paid')
             WHERE agent_id='$agent_id' AND day_number='$day'"
        );
    } else {
        mysqli_query(
            $connect,
            "INSERT INTO payments (agent_id, day_number, status)
             VALUES ('$agent_id', '$day', 'paid')"
        );
    }

    header("Location: agent_payment.php?id=$agent_id");
    exit;
}

/* =======================
   FETCH PAYMENTS
======================= */
$payments = [];
$q = mysqli_query(
    $connect,
    "SELECT day_number, status FROM payments WHERE agent_id='$agent_id'"
);
while ($row = mysqli_fetch_assoc($q)) {
    $payments[(int)$row['day_number']] = $row['status'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Agent Payment Schedule</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background:#f4f6f9;
        }

        /* Desktop layout */
        .content-area {
            margin-left:240px;
            padding:40px;
        }

        .table-card {
            background:#fff;
            padding:20px;
            border-radius:14px;
            box-shadow:0 6px 16px rgba(0,0,0,.1);
        }

        /* ✅ MOBILE: remove sidebar completely */
        @media (max-width:768px) {
            .sidebar {
                display:none !important;
            }

            .content-area {
                margin-left:0 !important;
                padding:15px !important;
            }
        }
    </style>
</head>

<body>

<!-- SIDEBAR (DESKTOP ONLY) -->
<div class="d-none d-md-block sidebar">
    <?php include 'sidebar.php'; ?>
</div>

<div class="content-area">
    <h3 class="mb-3">💵 Payment Schedule – <?= htmlspecialchars($agent['name']) ?></h3>

    <div class="table-card">
        <div class="table-responsive">
            <table class="table table-bordered table-striped text-center align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>Day</th>
                        <th>Remaining Days</th>
                        <th>Total Given</th>
                        <th>Balance</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>

<?php
$remaining_days = $total_days;
$paid_days = 0;

for ($day = 1; $day <= $total_days; $day++) {

    $status = $payments[$day] ?? 'unpaid';

    // ✅ Total given increases per day (FIX)
    $total_given = $day * $daily_amount;

    // Count paid days
    if ($status === 'paid') {
        $paid_days++;
    }

    // Balance depends only on paid days
    $balance = $total_amount - ($paid_days * $daily_amount);
    if ($balance < 0) $balance = 0;

    $remaining_days = $total_days - $paid_days;
?>
<tr>
    <td>Day <?= $day ?></td>
    <td><?= $remaining_days ?></td>
    <td>₹<?= number_format($total_given) ?></td>
    <td>₹<?= number_format($balance) ?></td>
    <td>
        <span class="badge <?= $status === 'paid' ? 'bg-success' : 'bg-danger' ?>">
            <?= ucfirst($status) ?>
        </span>
    </td>
    <td>
        <a href="?id=<?= $agent_id ?>&pay_day=<?= $day ?>"
           class="btn btn-sm <?= $status === 'paid' ? 'btn-warning' : 'btn-success' ?>">
            <?= $status === 'paid' ? 'Mark Unpaid' : 'Mark Paid' ?>
        </a>
    </td>
</tr>
<?php } ?>


                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
