<?php
session_start();

/* =====================
   AUTH CHECK
===================== */
if (!isset($_SESSION['superadmin_id'])) {
    header("Location: index.php");
    exit;
}

/* =====================
   DB CONNECTION
===================== */
$connect = mysqli_connect("localhost", "sumisha_agent", "Payment@665", "sumisha_pay");
if (!$connect) die("DB Error");

/* Fetch all agents */
$agents = mysqli_query($connect, "SELECT * FROM agents ORDER BY id DESC");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Agent Details</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
        }

        /* Desktop spacing for sidebar */
        .content-area {
            margin-left: 240px;
            padding: 40px;
        }

        .table-card {
            background: white;
            padding: 20px;
            border-radius: 14px;
            box-shadow: 0 6px 15px rgba(0,0,0,0.1);
        }

        h3 {
            font-weight: 800;
            margin-bottom: 20px;
        }

        /* Mobile adjustments */
        @media (max-width: 768px) {
            .content-area {
                margin-left: 0;
                padding: 20px;
            }
        }
    </style>
</head>

<body>

<!-- MOBILE NAVBAR -->
<nav class="navbar navbar-dark bg-dark d-md-none">
    <div class="container-fluid">
        <span class="navbar-brand">👑 Super Admin</span>
        <button class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#mobileMenu">
            <span class="navbar-toggler-icon"></span>
        </button>
    </div>
</nav>

<!-- MOBILE MENU -->
<div class="collapse bg-dark d-md-none" id="mobileMenu">
    <div class="p-3">
        <a href="superadmin_dashboard.php" class="d-block text-white mb-2">🏠 Dashboard</a>
        <a href="create_agent.php" class="d-block text-white mb-2">➕ Create Agent</a>
        <a href="agent_details.php" class="d-block text-white mb-2">👥 All Agents</a>
        <a href="approved_payments.php" class="d-block text-white mb-2">✅ Approved Payments</a>
        <a href="logout.php" class="d-block text-danger">🚪 Logout</a>
    </div>
</div>

<!-- DESKTOP SIDEBAR -->
<div class="d-none d-md-block">
    <?php include 'sidebar.php'; ?>
</div>

<div class="content-area">
    <h3>👥 Agent Details</h3>

    <div class="table-card table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>Agent Name</th>
                    <th style="width:120px;">Action</th>
                </tr>
            </thead>

            <tbody>
                <?php if (mysqli_num_rows($agents) > 0): ?>
                    <?php while ($a = mysqli_fetch_assoc($agents)): ?>
                        <tr>
                            <td><?= htmlspecialchars($a['name']) ?></td>
                            <td>
                                <a href="agent_payment.php?id=<?= $a['id'] ?>"
                                   class="btn btn-primary btn-sm w-100">
                                    Pay
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="2" class="text-center text-muted">
                            No agents found
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
