<?php
include "db.php";

// Fetch all agents
$agents = mysqli_query($connect, "SELECT * FROM agents ORDER BY id DESC");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Super Admin - Agents</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">

<div class="container mt-5">
    <h3 class="mb-4">Super Admin Dashboard – Agents</h3>

    <table class="table table-bordered bg-white shadow">
        <thead class="table-dark">
            <tr>
                <th width="200">Agent Name</th>
                <th width="200">Action</th>
                <th>Payment Details</th>
            </tr>
        </thead>

        <tbody>

        <?php while($a = mysqli_fetch_assoc($agents)) { ?>
        <tr>
            <td><?= $a['name'] ?></td>

            <td>
                <?php if($a['payment_approved'] == 0) { ?>
                    
                    <!-- Approve Button -->
                    <a href="approve_payment.php?id=<?= $a['id'] ?>" 
                       class="btn btn-success btn-sm">
                        Approve
                    </a>
                    <br>
                    <span class="badge bg-warning mt-2">Waiting Approval</span>

                <?php } else { ?>

                    <span class="badge bg-success">Approved</span>

                <?php } ?>
            </td>

            <td>
                <?php if($a['payment_approved'] == 1) { ?>

                    <!-- Fetch Payments -->
                    <?php
                    $agent_id = $a['id'];
                    $payments = mysqli_query($connect,
                        "SELECT * FROM payments WHERE agent_id='$agent_id' ORDER BY id ASC"
                    );
                    ?>

                    <table class="table table-sm table-striped border">
                        <thead class="table-secondary">
                            <tr>
                                <th>Day</th>
                                <th>Remaining Days</th>
                                <th>Given</th>
                                <th>Balance</th>
                            </tr>
                        </thead>

                        <tbody>
                        <?php while($p = mysqli_fetch_assoc($payments)) { ?>
                            <tr>
                                <td><?= $p['day'] ?></td>
                                <td><?= $p['remaining_days'] ?></td>
                                <td><?= $p['given'] ?></td>
                                <td><?= $p['balance'] ?></td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>

                <?php } else { ?>

                    <span class="text-muted">Approve to view payment table</span>

                <?php } ?>
            </td>
        </tr>
        <?php } ?>

        </tbody>
    </table>

</div>

</body>
</html>
