<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['agent_id'])) {
    header("Location: agent_login.php");
    exit;
}

$agent_name = $_SESSION['agent_name'];
?>

<style>
    .sidebar {
        position: fixed;
        top: 0;
        left: 0;
        width: 240px;
        height: 100vh;
        background: linear-gradient(180deg, #11998e, #38ef7d);
        color: #fff;
        padding: 25px 15px;
        box-shadow: 4px 0 15px rgba(0,0,0,.15);
        z-index: 1000;
    }

    .sidebar h4 {
        font-weight: 800;
        text-align: center;
        margin-bottom: 30px;
    }

    .sidebar a {
        display: block;
        padding: 12px 15px;
        margin-bottom: 10px;
        border-radius: 10px;
        color: #fff;
        text-decoration: none;
        font-weight: 600;
        transition: .2s;
    }

    .sidebar a:hover,
    .sidebar a.active {
        background: rgba(255,255,255,.25);
        transform: translateX(5px);
    }

    .sidebar .footer {
        position: absolute;
        bottom: 20px;
        width: 100%;
        text-align: center;
        font-size: 13px;
        opacity: .9;
    }
</style>

<div class="sidebar">
    <h4>👤 <?= htmlspecialchars($agent_name) ?></h4>

    <a href="admin_dashboard.php">🏠 Dashboard</a>

    <a href="agent_payments.php">📅 Payment Schedule</a>

    <a href="agent_profile.php">👤 My Profile</a>

    <a href="logout.php">🚪 Logout</a>

    <div class="footer">
        Agent Panel
    </div>
</div>
