<?php
session_start();

$connect = mysqli_connect("localhost", "sumisha_agent", "Payment@665", "sumisha_pay");
if (!$connect) die("DB Error");

/* ======================
   AGENT AUTH
====================== */
if (!isset($_SESSION['agent_id'])) {
    header("Location: agent_login.php");
    exit;
}

$agent_id = $_SESSION['agent_id'];

/* ======================
   AGENT INFO
====================== */
$agent = mysqli_fetch_assoc(
    mysqli_query($connect, "SELECT * FROM agents WHERE id='$agent_id'")
);
?>

<!DOCTYPE html>
<html>
<head>
    <title>My Profile</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family:'Segoe UI',sans-serif;
            background:#f4f6f9;
        }

        .content-area {
            margin-left:240px;
            padding:40px;
        }

        .profile-card {
            max-width:600px;
            background:#fff;
            padding:30px;
            border-radius:16px;
            box-shadow:0 8px 20px rgba(0,0,0,.1);
        }

        @media (max-width:768px) {
            .content-area {
                margin-left:0;
                padding:20px;
            }
        }
    </style>
</head>

<body>

<!-- MOBILE NAVBAR -->
<nav class="navbar navbar-dark bg-dark d-md-none">
    <div class="container-fluid">
        <span class="navbar-brand">👤 My Profile</span>
        <button class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#agentMenu">
            <span class="navbar-toggler-icon"></span>
        </button>
    </div>
</nav>

<!-- MOBILE MENU -->
<div class="collapse bg-dark d-md-none" id="agentMenu">
    <div class="p-3">
        <a href="agent_dashboard.php" class="d-block text-white mb-2">🏠 Dashboard</a>
        <a href="agent_payments.php" class="d-block text-white mb-2">📅 Payments</a>
        <a href="agent_profile.php" class="d-block text-white mb-2">👤 My Profile</a>
        <a href="logout.php" class="d-block text-danger">🚪 Logout</a>
    </div>
</div>

<!-- DESKTOP SIDEBAR -->
<div class="d-none d-md-block">
    <?php include 'agent_sidebar.php'; ?>
</div>

<div class="content-area">
    <h3 class="mb-4">👤 My Profile</h3>

    <div class="profile-card">

        <div class="mb-3">
            <label class="fw-bold">Name</label>
            <input class="form-control" value="<?= htmlspecialchars($agent['name']) ?>" disabled>
        </div>

        <div class="mb-3">
            <label class="fw-bold">Username</label>
            <input class="form-control" value="<?= htmlspecialchars($agent['username']) ?>" disabled>
        </div>

        <div class="mb-3">
            <label class="fw-bold">Phone</label>
            <input class="form-control" value="<?= htmlspecialchars($agent['phone']) ?>" disabled>
        </div>

        <div class="mb-3">
            <label class="fw-bold">Email</label>
            <input class="form-control" value="<?= htmlspecialchars($agent['email']) ?>" disabled>
        </div>

        <div class="mb-3">
            <label class="fw-bold">Daily Amount</label>
            <input class="form-control" value="₹<?= number_format($agent['amount']) ?>" disabled>
        </div>

        <div class="mb-3">
            <label class="fw-bold">Payment Status</label>
            <input class="form-control"
                   value="<?= $agent['payment_approved'] ? 'Approved' : 'Pending' ?>"
                   disabled>
        </div>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
