<?php
session_start();

$connect = mysqli_connect("localhost", "sumisha_agent", "Payment@665", "sumisha_pay");
if (!$connect) die("Database connection failed");

/* ======================
   AGENT AUTH CHECK
====================== */
if (!isset($_SESSION['agent_id'])) {
    header("Location: agent_login.php");
    exit;
}

$agent_id = $_SESSION['agent_id'];

/* ======================
   AGENT INFO
====================== */
$agent = mysqli_fetch_assoc(
    mysqli_query($connect, "SELECT * FROM agents WHERE id='$agent_id'")
);
if (!$agent) die("Agent not found");

/* ======================
   CONFIG
====================== */
$total_amount = 100000;
$daily_amount = (int)$agent['amount'];
$total_days   = $daily_amount > 0 ? floor($total_amount / $daily_amount) : 0;

/* ======================
   FETCH PAID DAYS
====================== */
$paid_days = [];
$q = mysqli_query(
    $connect,
    "SELECT day_number 
     FROM payments 
     WHERE agent_id='$agent_id' AND status='paid'"
);
while ($row = mysqli_fetch_assoc($q)) {
    $paid_days[$row['day_number']] = true;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>My Payment Schedule</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body { font-family:'Segoe UI',sans-serif; background:#f4f6f9; }
        .content-area { margin-left:240px; padding:40px; }

        .table-card {
            background:#fff;
            padding:20px;
            border-radius:14px;
            box-shadow:0 6px 16px rgba(0,0,0,.1);
        }

        .paid-row { background:#e9f7ef; font-weight:600; }
        .unpaid-row { background:#fdecea; }

        @media(max-width:768px){
            .content-area { margin-left:0; padding:15px; }
            table { font-size:14px; }
        }
    </style>
</head>

<body>

<!-- MOBILE NAV -->
<nav class="navbar navbar-dark bg-dark d-md-none">
    <div class="container-fluid">
        <span class="navbar-brand">👤 Agent Panel</span>
        <button class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#menu">
            <span class="navbar-toggler-icon"></span>
        </button>
    </div>
</nav>

<div class="collapse bg-dark d-md-none" id="menu">
    <div class="p-3">
        <a href="agent_dashboard.php" class="d-block text-white mb-2">🏠 Dashboard</a>
        <a href="agent_payments.php" class="d-block text-white mb-2">📄 Payment Schedule</a>
        <a href="agent_profile.php" class="d-block text-white mb-2">👤 My Profile</a>
        <a href="logout.php" class="d-block text-danger">🚪 Logout</a>
    </div>
</div>

<!-- DESKTOP SIDEBAR -->
<div class="d-none d-md-block">
    <?php include 'agent_sidebar.php'; ?>
</div>

<div class="content-area">
    <h3 class="mb-3">📅 Payment Schedule</h3>

    <div class="table-card">
        <div class="table-responsive">
            <table class="table table-bordered align-middle text-center">
                <thead class="table-dark">
                    <tr>
                        <th>Day</th>
                        <th>Status</th>
                        <th>Remaining Days</th>
                        <th>Total Given</th>
                        <th>Balance</th>
                    </tr>
                </thead>
                <tbody>

<?php
$paid_count = 0;

for ($day = 1; $day <= $total_days; $day++) {

    $is_paid = isset($paid_days[$day]);

    if ($is_paid) {
        $paid_count++;
    }

    // ✅ FIXED LOGIC
    $total_given = $day * $daily_amount;
    $balance = $total_amount - ($paid_count * $daily_amount);
    if ($balance < 0) $balance = 0;

    $remaining_days = $total_days - $paid_count;
?>
<tr class="<?= $is_paid ? 'paid-row' : 'unpaid-row' ?>">
    <td>Day <?= $day ?></td>
    <td>
        <span class="badge <?= $is_paid ? 'bg-success' : 'bg-danger' ?>">
            <?= $is_paid ? 'Paid' : 'Unpaid' ?>
        </span>
    </td>
    <td><?= $remaining_days ?></td>
    <td>₹<?= number_format($total_given) ?></td>
    <td>₹<?= number_format($balance) ?></td>
</tr>
<?php } ?>

                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
