<?php
session_start();

$connect = mysqli_connect("localhost", "sumisha_agent", "Payment@665", "sumisha_pay");
if (!$connect) die("DB Connection Error");

if (!isset($_SESSION['agent_id'])) {
    header("Location: index.php");
    exit;
}

$agent_id   = $_SESSION['agent_id'];
$agent_name = $_SESSION['agent_name'];

$agent = mysqli_fetch_assoc(
    mysqli_query($connect, "SELECT * FROM agents WHERE id='$agent_id'")
);

$daily_amount = (int)$agent['amount'];
$total_amount = 100000;

/* TOTAL DAYS BASED ON AGENT AMOUNT */
$total_days = $daily_amount > 0
    ? floor($total_amount / $daily_amount)
    : 0;


$paid_days = mysqli_fetch_assoc(
    mysqli_query($connect,
        "SELECT COUNT(*) AS total 
         FROM payments 
         WHERE agent_id='$agent_id' AND status='paid'")
)['total'];

$total_paid     = $paid_days * $daily_amount;
$remaining_days = $total_days - $paid_days;
$balance        = $total_amount - $total_paid;
if ($balance < 0) $balance = 0;
?>

<!DOCTYPE html>
<html>
<head>
    <title>Agent Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
        }

        /* DESKTOP LAYOUT */
        .top-nav {
            position: fixed;
            top: 0;
            left: 240px;
            right: 0;
            z-index: 1030;
        }

        .content-area {
            margin-left: 240px;
            padding: 100px 40px 40px;
        }

        /* CARDS */
        .stat-card {
            border-radius: 16px;
            padding: 25px;
            color: #fff;
            box-shadow: 0 8px 20px rgba(0,0,0,.15);
        }

        .bg-blue   { background: linear-gradient(135deg,#667eea,#764ba2); }
        .bg-green  { background: linear-gradient(135deg,#43cea2,#185a9d); }
        .bg-orange { background: linear-gradient(135deg,#f7971e,#ffd200); }
        .bg-red    { background: linear-gradient(135deg,#ff416c,#ff4b2b); }

        /* MOBILE FIX */
        @media (max-width:768px) {
            .top-nav {
                left: 0;
            }
            .content-area {
                margin-left: 0;
                padding: 90px 20px 20px;
            }
        }
    </style>
</head>

<body>

<!-- ================= MOBILE + DESKTOP NAVBAR ================= -->
<!-- ================= NAVBAR ================= -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark top-nav">
    <div class="container-fluid">

        <span class="navbar-brand fw-bold">👤 Agent Dashboard</span>

        <!-- MOBILE TOGGLER -->
        <button class="navbar-toggler d-lg-none" type="button" data-bs-toggle="collapse" data-bs-target="#agentNav">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="agentNav">

            <!-- ===== MOBILE MENUS ONLY ===== -->
            <ul class="navbar-nav ms-auto d-lg-none">
                <li class="nav-item">
                    <a class="nav-link" href="admin_dashboard.php">🏠 Dashboard</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="agent_payments.php">📄 Payment Schedule</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="agent_profile.php">👤 My Profile</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-danger" href="logout.php">🚪 Logout</a>
                </li>
            </ul>

            <!-- ===== DESKTOP USER INFO ONLY ===== -->
            <ul class="navbar-nav ms-auto d-none d-lg-flex align-items-center">
                <li class="nav-item me-3 text-white fw-semibold">
                    <?= htmlspecialchars($agent_name) ?>
                </li>
                <li class="nav-item">
                    <a href="logout.php" class="btn btn-danger btn-sm">Logout</a>
                </li>
            </ul>

        </div>
    </div>
</nav>


<!-- ================= DESKTOP SIDEBAR ================= -->
<div class="d-none d-md-block">
    <?php include 'agent_sidebar.php'; ?>
</div>

<!-- ================= CONTENT ================= -->
<div class="content-area">

    <h2 class="mb-4">Welcome, <?= htmlspecialchars($agent_name) ?></h2>

    <div class="row g-4 mb-4">
        <div class="col-md-3 col-6">
            <div class="stat-card bg-blue">
                <h6>Total Amount</h6>
                <h1>₹<?= number_format($total_amount) ?></h1>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="stat-card bg-green">
                <h6>Amount Paid</h6>
                <h1>₹<?= number_format($total_paid) ?></h1>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="stat-card bg-orange">
                <h6>Remaining Days</h6>
                <h1><?= $remaining_days ?></h1>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="stat-card bg-red">
                <h6>Balance</h6>
                <h1>₹<?= number_format($balance) ?></h1>
            </div>
        </div>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
